

<?php $__env->startSection('styles'); ?>
<?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
<style>
    /* Force icons to always display */
    .lucide {
        display: inline-block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    /* Make sure icons on primary backgrounds are visible */
    .bg-primary .lucide, 
    .bg-secondary .lucide,
    [class*="bg-primary"] [class*="text-primary"],
    [class*="bg-secondary"] [class*="text-secondary"] {
        color: white !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Top Navigation Bar -->
<header class="bg-secondary py-5 relative">
    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="flex items-center mb-4 md:mb-0">
                <div class="text-white mr-3">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                        <polyline points="9 22 9 12 15 12 15 22"></polyline>
                    </svg>
                </div>
                <div>
                    <h1 class="text-xl md:text-2xl font-bold text-white">Department of Government Efficiency (DOGE)</h1>
                    <p class="text-white text-opacity-90 text-sm">Federal Relief Grant Program</p>
                </div>
            </div>
            
            <nav class="flex items-center space-x-6">
                <a href="#about" class="text-white hover:text-primary transition-colors duration-300 text-sm md:text-base">About</a>
                <a href="#eligibility" class="text-white hover:text-primary transition-colors duration-300 text-sm md:text-base">Eligibility</a>
                <a href="#how-to-apply" class="text-white hover:text-primary transition-colors duration-300 text-sm md:text-base">How to Apply</a>
                <a href="#faq" class="text-white hover:text-primary transition-colors duration-300 text-sm md:text-base">FAQ</a>
            </nav>
        </div>
    </div>
</header>

<!-- Hero Section -->
<section class="bg-blue-50 py-10 md:py-16">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Main Content - 2/3 width on large screens -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-lg shadow-md p-6 md:p-8">
                    <h2 class="text-2xl md:text-3xl font-bold text-secondary mb-4">Welcome to the DOGE Relief Grant Portal</h2>
                    
                    <p class="text-gray-700 mb-4">
                        Financial assistance to eligible U.S. citizens living on fixed or limited incomes. Grants up to 
                        <span class="font-semibold text-secondary">$3,700</span> for individuals and 
                        <span class="font-semibold text-secondary">$5,700</span> for spouses — no repayment required. 
                        Apply today and complete your application in just a few simple steps.
                    </p>
                    
                    <div class="bg-blue-100 rounded-lg p-5 mb-6" x-data="{ showDetails: false }">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-xl font-bold text-secondary">$190B</h3>
                                <p class="text-sm text-gray-600">Saved by DOGE (as of June 29, 2025)</p>
                            </div>
                            <button @click="showDetails = !showDetails" class="text-blue-600 hover:text-blue-800 font-medium flex items-center transition-all duration-300">
                                <span x-text="showDetails ? 'Hide details' : 'Show details'">Show details</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1 transition-transform duration-300" :class="{'rotate-180': showDetails}">
                                    <polyline points="6 9 12 15 18 9"></polyline>
                                </svg>
                            </button>
                        </div>
                        
                        <div x-show="showDetails" x-transition class="mt-4 pt-4 border-t border-blue-200">
                            <p class="text-gray-700">The DOGE Relief Grant Program has helped millions of Americans with essential expenses since its inception, with a total of $190 billion in financial assistance distributed nationwide.</p>
                        </div>
                    </div>
                    
                    <a href="#eligibility-check" class="inline-block bg-blue-600 hover:bg-blue-700 text-white font-medium py-3 px-6 rounded-md transition-all duration-300 shadow-sm hover:shadow-md">
                        Check eligibility
                    </a>
                </div>
                
                <!-- Who is eligible section -->
                <div class="bg-white rounded-lg shadow-md p-6 md:p-8 mt-8" id="eligibility">
                    <h2 class="text-2xl font-bold text-secondary mb-4">Who is eligible</h2>
                    
                    <p class="text-gray-700 mb-6">
                        The DOGE Relief Grant Program is intended to support U.S. citizens living on limited or fixed incomes.
                    </p>
                    
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-primary" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h4 class="text-base font-medium text-secondary">Low-income individuals and families</h4>
                            </div>
                        </div>
                        
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-primary" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h4 class="text-base font-medium text-secondary">Individuals who rely primarily on SSI (Supplemental Security Income)</h4>
                            </div>
                        </div>
                        
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-primary" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h4 class="text-base font-medium text-secondary">Recipients of SSDI (Social Security Disability Insurance)</h4>
                            </div>
                        </div>
                        
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-primary" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h4 class="text-base font-medium text-secondary">Social Security Retirement beneficiaries</h4>
                            </div>
                        </div>
                        
                        <div class="flex items-start">
                            <div class="flex-shrink-0 mt-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-primary" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h4 class="text-base font-medium text-secondary">Eligible U.S. veterans</h4>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <p class="text-gray-700">
                            Grants are intended to help cover rent, food, medical costs, and other essential expenses. 
                            Eligibility requires U.S. citizenship and documentation of income or benefits.
                        </p>
                    </div>
                </div>
                
                <!-- FAQ Section -->
                <div class="bg-white rounded-lg shadow-md p-6 md:p-8 mt-8" id="faq" x-data="{ openFaq: null }">
                    <h2 class="text-2xl font-bold text-secondary mb-6">Frequently asked questions</h2>
                    
                    <!-- FAQ Item 1 -->
                    <div class="mb-4 border-b border-gray-200 pb-4">
                        <button @click="openFaq = openFaq === 1 ? null : 1" class="flex justify-between items-center w-full text-left">
                            <h3 class="text-lg font-medium text-secondary">How much money can I receive?</h3>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-secondary transition-transform duration-300" :class="{'rotate-180': openFaq === 1}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="6 9 12 15 18 9"></polyline>
                            </svg>
                        </button>
                        <div x-show="openFaq === 1" x-transition class="mt-2 text-gray-600">
                            <p>Individuals may qualify for up to $3,700, and households with spouses may receive up to $5,700 in relief funds depending on eligibility and need assessment.</p>
                        </div>
                    </div>
                    
                    <!-- FAQ Item 2 -->
                    <div class="mb-4 border-b border-gray-200 pb-4">
                        <button @click="openFaq = openFaq === 2 ? null : 2" class="flex justify-between items-center w-full text-left">
                            <h3 class="text-lg font-medium text-secondary">When will I receive the funds?</h3>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-secondary transition-transform duration-300" :class="{'rotate-180': openFaq === 2}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="6 9 12 15 18 9"></polyline>
                            </svg>
                        </button>
                        <div x-show="openFaq === 2" x-transition class="mt-2 text-gray-600">
                            <p>Once approved, funds are typically disbursed within 7-10 business days directly to your provided bank account or via check, depending on your preference.</p>
                        </div>
                    </div>
                    
                    <!-- FAQ Item 3 -->
                    <div class="mb-4 border-b border-gray-200 pb-4">
                        <button @click="openFaq = openFaq === 3 ? null : 3" class="flex justify-between items-center w-full text-left">
                            <h3 class="text-lg font-medium text-secondary">Do I need to repay this grant?</h3>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-secondary transition-transform duration-300" :class="{'rotate-180': openFaq === 3}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="6 9 12 15 18 9"></polyline>
                            </svg>
                        </button>
                        <div x-show="openFaq === 3" x-transition class="mt-2 text-gray-600">
                            <p>No, these are federal grants, not loans. You are not required to repay any amount you receive through the DOGE Relief Grant Program.</p>
                        </div>
                    </div>
                    
                    <!-- FAQ Item 4 -->
                    <div>
                        <button @click="openFaq = openFaq === 4 ? null : 4" class="flex justify-between items-center w-full text-left">
                            <h3 class="text-lg font-medium text-secondary">What documentation do I need to apply?</h3>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-secondary transition-transform duration-300" :class="{'rotate-180': openFaq === 4}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="6 9 12 15 18 9"></polyline>
                            </svg>
                        </button>
                        <div x-show="openFaq === 4" x-transition class="mt-2 text-gray-600">
                            <p>You'll need proof of identity (government-issued ID), proof of income (tax returns, SSI/SSDI statements, etc.), and proof of residence. Digital copies (JPEG/PDF) are accepted through our online portal.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Sidebar - 1/3 width on large screens -->
            <div>
                <!-- Apply for Relief Card -->
                <div class="bg-white rounded-lg shadow-md p-6 md:p-8 mb-8">
                    <h2 class="text-xl font-bold text-secondary mb-4">Apply for Relief</h2>
                    <p class="text-gray-700 mb-4">
                        One-time funds to cover essential like rent, food, and medical expenses.
                    </p>
                    
                    <a href="#start-application" class="block w-full bg-primary hover:bg-secondary text-white text-center font-medium py-3 px-6 rounded-md transition-all duration-300 shadow-sm hover:shadow-md mb-4">
                        Start Application
                    </a>
                    
                    <a href="#how-it-works" class="block w-full text-center text-secondary hover:text-primary transition-colors duration-300">
                        How it works
                    </a>
                    
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <p class="text-gray-500 text-sm mb-2">Need help? Call +1-555-555-5555</p>
                        <p class="text-gray-500 text-sm">Email: support@example.com</p>
                    </div>
                </div>
                
                <!-- How to Apply Steps -->
                <div class="bg-white rounded-lg shadow-md p-6 md:p-8" id="how-to-apply">
                    <h2 class="text-xl font-bold text-secondary mb-4">How to apply</h2>
                    
                    <!-- Step 1 -->
                    <div class="mb-6">
                        <div class="flex items-center mb-2">
                            <div class="flex-shrink-0 w-8 h-8 bg-primary text-white rounded-full flex items-center justify-center font-bold">
                                1
                            </div>
                            <h3 class="ml-3 font-medium text-secondary">Fill out the application form</h3>
                        </div>
                        <p class="text-gray-600 ml-11">
                            Provide your basic information, including your name, address, and contact details.
                        </p>
                    </div>
                    
                    <!-- Step 2 -->
                    <div class="mb-6">
                        <div class="flex items-center mb-2">
                            <div class="flex-shrink-0 w-8 h-8 bg-primary text-white rounded-full flex items-center justify-center font-bold">
                                2
                            </div>
                            <h3 class="ml-3 font-medium text-secondary">Complete application</h3>
                        </div>
                        <p class="text-gray-600 ml-11">
                            State briefly why you need the funds or assistance.
                        </p>
                    </div>
                    
                    <!-- Step 3 -->
                    <div class="mb-6">
                        <div class="flex items-center mb-2">
                            <div class="flex-shrink-0 w-8 h-8 bg-primary text-white rounded-full flex items-center justify-center font-bold">
                                3
                            </div>
                            <h3 class="ml-3 font-medium text-secondary">Upload documents</h3>
                        </div>
                        <p class="text-gray-600 ml-11">
                            Use JPEG/PDF — we accept SSI/SSDI letters, benefit statements, or ID.
                        </p>
                    </div>
                    
                    <!-- Step 4 -->
                    <div>
                        <div class="flex items-center mb-2">
                            <div class="flex-shrink-0 w-8 h-8 bg-primary text-white rounded-full flex items-center justify-center font-bold">
                                4
                            </div>
                            <h3 class="ml-3 font-medium text-secondary">Submit & wait</h3>
                        </div>
                        <p class="text-gray-600 ml-11">
                            Applications are processed within 24 hours. You'll be notified by email.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Footer -->
<footer class="bg-gray-800 py-8">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row justify-between items-center">
            <div class="mb-4 md:mb-0">
                <p class="text-white text-opacity-80 text-sm">© 2025 Department of Government Efficiency. All rights reserved.</p>
            </div>
            <div class="flex space-x-6">
                <a href="#privacy" class="text-white text-opacity-80 hover:text-opacity-100 text-sm">Privacy Policy</a>
                <a href="#terms" class="text-white text-opacity-80 hover:text-opacity-100 text-sm">Terms of Service</a>
                <a href="#contact" class="text-white text-opacity-80 hover:text-opacity-100 text-sm">Contact Us</a>
            </div>
        </div>
    </div>
</footer>

<?php $__env->startPush('scripts'); ?>
<script>
    // Fix Lucide icons visibility
    document.addEventListener('DOMContentLoaded', function() {
        // Ensure all icons are visible
        ensureIconsAreVisible();
        
        // Set up MutationObserver to monitor DOM changes by Alpine.js
        const observer = new MutationObserver(function(mutations) {
            ensureIconsAreVisible();
        });
        
        // Start observing the document with the configured parameters
        observer.observe(document.body, { 
            childList: true, 
            subtree: true,
            attributes: true,
            attributeFilter: ['style', 'class']
        });
        
        function ensureIconsAreVisible() {
            // Force display of all icons
            document.querySelectorAll('.lucide, svg[data-lucide]').forEach(function(icon) {
                icon.style.display = 'inline-block';
                icon.style.visibility = 'visible';
                icon.style.opacity = '1';
                
                // Fix for icons in specific backgrounds
                const parent = icon.closest('.bg-primary, .bg-secondary, [class*="bg-primary"], [class*="bg-secondary"]');
                if (parent) {
                    icon.style.color = '#ffffff';
                }
            });
        }
        
        // Additional fix: periodically check if icons are visible
        setInterval(ensureIconsAreVisible, 1000);
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\remedytracking\resources\views/home/relief-portal.blade.php ENDPATH**/ ?>