<?php $__env->startComponent('mail::message'); ?>
# New Quote Request Received

A new quote request has been submitted on <?php echo e($settings->site_title); ?>.

**Reference Number:** <?php echo e($quoteRequest->reference_number); ?>


## Customer Information
- **Name:** <?php echo e($quoteRequest->full_name); ?>

- **Email:** <?php echo e($quoteRequest->email); ?>

- **Phone:** <?php echo e($quoteRequest->phone ?? 'Not provided'); ?>

- **Company:** <?php echo e($quoteRequest->company_name ?? 'Not provided'); ?>


## Shipment Details
- **Freight Type:** <?php echo e($quoteRequest->freight_type); ?>

- **From:** <?php echo e($quoteRequest->departure_country); ?>

- **To:** <?php echo e($quoteRequest->recipient_country); ?>

- **Weight:** <?php echo e($quoteRequest->weight ?? 'Not specified'); ?> KG
- **Dimensions:** <?php echo e($quoteRequest->dimensions ?? 'Not specified'); ?>

- **Priority:** <?php echo e(ucfirst($quoteRequest->priority)); ?>

- **Insurance:** <?php echo e($quoteRequest->insurance ? 'Yes' : 'No'); ?>

- **Expected Delivery:** <?php echo e($quoteRequest->expected_delivery_date ? $quoteRequest->expected_delivery_date->format('M d, Y') : 'Not specified'); ?>


<?php if($quoteRequest->description): ?>
## Description
<?php echo e($quoteRequest->description); ?>

<?php endif; ?>

<?php $__env->startComponent('mail::button', ['url' => url('/admin/dashboard')]); ?>
View in Admin Panel
<?php echo $__env->renderComponent(); ?>

Please review this request and provide a quote as soon as possible.

Thanks,<br>
<?php echo e($settings->site_title); ?> System
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/sbrbot/trackmate.sbrbot.trading/resources/views/emails/quote-request-received.blade.php ENDPATH**/ ?>