@component('mail::message')
# Quote Request Received - Thank You!

Dear {{ $quoteRequest->full_name }},

Thank you for your interest in our shipping services! We have received your quote request and our team is reviewing it.

**Your Reference Number:** {{ $quoteRequest->reference_number }}

## Your Request Summary
- **Freight Type:** {{ $quoteRequest->freight_type }}
- **From:** {{ $quoteRequest->departure_country }}
- **To:** {{ $quoteRequest->recipient_country }}
- **Priority:** {{ ucfirst($quoteRequest->priority) }} shipping
- **Insurance:** {{ $quoteRequest->insurance ? 'Included' : 'Not requested' }}

## What Happens Next?
1. Our logistics experts will review your requirements
2. We'll prepare a detailed quote with competitive pricing
3. You'll receive your personalized quote within **24 hours**
4. We may contact you if we need additional information

@component('mail::button', ['url' => url('/track-order')])
Track Your Request
@endcomponent

If you have any questions or need immediate assistance, please don't hesitate to contact us.

**Contact Information:**
- Email: {{ $settings->email ?? 'support@company.com' }}
- Phone: {{ $settings->phone ?? 'N/A' }}

Thanks for choosing {{ $settings->site_title }}!<br>
Customer Service Team
@endcomponent
