@extends('layouts.base')

@section('content')
<div class="container py-8 max-w-2xl mx-auto">
    <h1 class="text-2xl font-bold mb-6">Shipment Details</h1>
    <div class="bg-white shadow rounded p-6">
        <div class="mb-4">
            <strong>Tracking Number:</strong> {{ $shipment->trackingnumber }}
        </div>
        <div class="mb-4">
            <strong>Sender:</strong> {{ $shipment->sender_name }}<br>
            <strong>Address:</strong> {{ $shipment->sender_address }}<br>
            <strong>Email:</strong> {{ $shipment->sender_email }}<br>
            <strong>Phone:</strong> {{ $shipment->sender_phone }}
        </div>
        <div class="mb-4">
            <strong>Receiver:</strong> {{ $shipment->receiver_name }}<br>
            <strong>Address:</strong> {{ $shipment->receiver_address }}<br>
            <strong>Email:</strong> {{ $shipment->receiver_email }}<br>
            <strong>Phone:</strong> {{ $shipment->receiver_phone }}
        </div>
        <div class="mb-4">
            <strong>Origin:</strong> {{ $shipment->origin }}<br>
            <strong>Destination:</strong> {{ $shipment->destination }}
        </div>
        <div class="mb-4">
            <strong>Shipment Type:</strong> {{ $shipment->shipment_type }}<br>
            <strong>Freight Type:</strong> {{ $shipment->freight_type }}<br>
            <strong>Weight:</strong> {{ $shipment->weight }}
        </div>
        <div class="mb-4">
            <strong>Date Shipped:</strong> {{ $shipment->date_shipped }}<br>
            <strong>Expected Delivery:</strong> {{ $shipment->expected_delivery }}
        </div>
        <div class="mb-4">
            <strong>Status:</strong> {{ $shipment->status }}<br>
            <strong>Progress:</strong> {{ $shipment->percentage_complete }}%
        </div>
        <div class="mb-4">
            <strong>Description:</strong> {{ $shipment->description }}
        </div>
        @if($shipment->photo)
        <div class="mb-4">
            <strong>Photo:</strong><br>
            <img src="{{ asset($shipment->photo) }}" alt="Shipment Photo" class="w-48 h-auto rounded">
        </div>
        @endif
        <div class="mb-4">
            <strong>Current Location:</strong> {{ $shipment->location }}
        </div>
        <a href="{{ route('admin.shipments.edit', $shipment->id) }}" class="bg-yellow-500 text-white px-4 py-2 rounded">Edit Shipment</a>
        <a href="{{ route('admin.shipments.index') }}" class="ml-2 bg-gray-300 text-gray-800 px-4 py-2 rounded">Back to List</a>
        <a href="{{ route('admin.shipments.updateform', $shipment->id) }}" class="bg-green-600 text-white px-4 py-2 rounded ml-2">Update Status</a>
    </div>
</div>
@endsection
