<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class QuoteRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'freight_type',
        'email',
        'departure_country',
        'weight',
        'recipient_country',
        'expected_delivery_date',
        'full_name',
        'phone',
        'company_name',
        'description',
        'dimensions',
        'priority',
        'insurance',
        'status',
        'quoted_amount',
        'admin_notes',
        'reference_number'
    ];

    protected $casts = [
        'insurance' => 'boolean',
        'expected_delivery_date' => 'date',
        'quoted_amount' => 'decimal:2',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (!$model->reference_number) {
                $model->reference_number = 'QR-' . strtoupper(Str::random(8));
            }
        });
    }

    public function getPriorityBadgeAttribute()
    {
        $badges = [
            'economy' => 'bg-blue-100 text-blue-800',
            'standard' => 'bg-green-100 text-green-800',
            'express' => 'bg-red-100 text-red-800',
        ];

        return $badges[$this->priority] ?? 'bg-gray-100 text-gray-800';
    }

    public function getStatusBadgeAttribute()
    {
        $badges = [
            'pending' => 'bg-yellow-100 text-yellow-800',
            'quoted' => 'bg-blue-100 text-blue-800',
            'processed' => 'bg-green-100 text-green-800',
            'cancelled' => 'bg-red-100 text-red-800',
        ];

        return $badges[$this->status] ?? 'bg-gray-100 text-gray-800';
    }
}
