<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Settings;
use App\Models\Plans;
use App\Models\Agent;
use App\Models\User_plans;
use App\Models\Admin;
use App\Models\Faq;
use App\Models\Images;
use App\Models\Testimony;
use App\Models\Content;
use App\Models\Asset;
use Illuminate\Support\Facades\Validator;
use App\Models\Mt4Details;
use App\Models\Deposit;
use App\Models\Wdmethod;
use App\Models\Withdrawal;
use App\Models\Cp_transaction;
use App\Models\TermsPrivacy;
use App\Models\Tp_Transaction;
use App\Models\QuoteRequest;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use App\Mail\NewNotification;
use App\Mail\QuoteRequestReceived;
use App\Mail\QuoteRequestConfirmation;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;

class HomePageController extends Controller
{
    public function index(){
        $settings=Settings::where('id', '=', '1')->first();
        //sum total deposited
        $total_deposits = DB::table('deposits')->select(DB::raw("SUM(amount) as total"))->
        where('status','Processed')->get();

        //sum total withdrawals
        $total_withdrawals = DB::table('withdrawals')->select(DB::raw("SUM(amount) as total"))->
        where('status','Processed')->get();


        return view('home.index')->with(array(
            'settings' => $settings,
            'total_users' => User::count(),
            'plans' => Plans::all(),
            'total_deposits' => $total_deposits,
            'total_withdrawals' => $total_withdrawals,
            'faqs'=> Faq::orderby('id', 'desc')->get(),
            'test'=> Testimony::orderby('id', 'desc')->get(),
            'withdrawals' => Withdrawal::orderby('id','DESC')->take(7)->get(),
            'deposits' => Deposit::orderby('id','DESC')->take(7)->get(),
            'title' => $settings->site_title,
            'mplans' => Plans::where('type','Main')->get(),
            'pplans' => Plans::where('type','Promo')->get(),
        ));
    }

    //Licensing and registration route
    public function licensing(){

        return view('home.licensing')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),
            'pplans' => Plans::where('type','Promo')->get(),
            'title' => 'Licensing, regulation and registration',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

    //Terms of service route
    public function terms(){

        return view('home.terms')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),
            'title' => 'Terms of Service',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }


    public function track(){

        return view('home.track-order')
        ->with(array(

            'title' => 'Trackng Your order',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

    public function quote_request(){

        return view('home.request-quote')
        ->with(array(

            'title' => 'Request A quote',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }


    public function  services(){

        return view('home.services')
        ->with(array(

            'title' => 'Our Services',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }




    public function printnow($id){


        $user = User::where('id', $id)->first();



        return view('home.printinvoice', [

            'title' => " Print Invoice",
            'user' => $user,
            'settings' => Settings::where('id', '=', '1')->first(),
        ]);

        }
    public function trackingresult(Request $request)
    {
        // Validate the tracking number input
        $request->validate([
            'trackingnumber' => ['required', 'string', 'max:100'],
        ], [
            'trackingnumber.required' => 'Please enter your tracking number to proceed.',
            'trackingnumber.max' => 'Tracking number is too long.',
        ]);

        $trackingnumber = trim($request->trackingnumber);
        $courier = User::where('trackingnumber', $trackingnumber)->first();

        if (!$courier) {
            return redirect()->back()->with('error', 'Sorry, we could not find a shipment with that tracking number. Please double-check your entry and try again. If you need assistance, contact our support team.');
        }

        $tracks = Tp_Transaction::where('user', $courier->id)->orderByDesc('id')->get();
        $latesttrack = Tp_Transaction::where('user', $courier->id)->orderBy('created_at', 'desc')->first();
        $settings = Settings::where('id', '=', '1')->first();

        return view('home.track-result', [
            'tracks' => $tracks,
            'title' => 'Tracking Result',
            'courier' => $courier,
            'settings' => $settings,
            'latesttrack' => $latesttrack,
        ]);
    }


    //Privacy policy route
    public function privacy(){
        $terms = TermsPrivacy::find(1);
        if ($terms->useterms == 'no') {
           return redirect()->back();
        }
        return view('home.privacy')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),
            'title' => 'Privacy Policy',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

    //FAQ route
    public function faq(){

        return view('home.faq')
        ->with(array(
            'title' => 'FAQs',
            'faqs'=> Faq::orderby('id', 'desc')->get(),
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }



     //license route
    public function license(){

        return view('home.license')
        ->with(array(
            'title' => 'License',
            'faqs'=> Faq::orderby('id', 'desc')->get(),
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }


  //license route
    public function security(){

        return view('home.security')
        ->with(array(
            'title' => 'security',
            'faqs'=> Faq::orderby('id', 'desc')->get(),
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }


    //about route
    public function about(){

        return view('home.about')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),

            'title' => 'About',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

    //Contact route
    public function contact(){
        return view('home.contact')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),
                'pplans' => Plans::where('type','Promo')->get(),

            'title' => 'Contact',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }



    //send contact message to admin email
    public function sendcontact(Request $request){

        $settings=Settings::where('id','1')->first();
        $objDemo = new \stdClass();
        $objDemo->message = substr(wordwrap($request['message'],70),0,350);
        $objDemo->sender = "$settings->site_name";
        $objDemo->date = \Carbon\Carbon::Now();
        $objDemo->subject = "$request->subject,  my email $request->email";
        Mail::bcc($settings->contact_email)->send(new NewNotification($objDemo));
        return redirect()->back()
        ->with('success', ' Your message was sent successfully!');
    }

    //handle quote request submission
    public function submit_quote(Request $request)
    {
        // Validation rules
        $validator = Validator::make($request->all(), [
            'freight_type' => 'required|string|in:Air Freight,Ocean Freight,Road Freight',
            'email' => 'required|email|max:255',
            'departure_country' => 'required|string|max:255',
            'weight' => 'nullable|string|max:50',
            'recipient_country' => 'required|string|max:255',
            'expected_delivery_date' => 'nullable|date|after:today',
            'full_name' => 'required|string|max:255',
            'phone' => 'nullable|string|max:20',
            'company_name' => 'nullable|string|max:255',
            'description' => 'nullable|string|max:1000',
            'dimensions' => 'nullable|string|max:100',
            'priority' => 'required|string|in:economy,standard,express',
            'insurance' => 'boolean',
        ], [
            'freight_type.required' => 'Please select a freight type.',
            'freight_type.in' => 'Please select a valid freight type.',
            'email.required' => 'Email address is required.',
            'email.email' => 'Please provide a valid email address.',
            'departure_country.required' => 'Departure country is required.',
            'recipient_country.required' => 'Recipient country is required.',
            'expected_delivery_date.after' => 'Expected delivery date must be in the future.',
            'full_name.required' => 'Full name is required.',
            'priority.required' => 'Please select shipping priority.',
            'priority.in' => 'Please select a valid shipping priority.',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'errors' => $validator->errors()
                ], 422);
            }
            return redirect()->back()->withErrors($validator)->withInput();
        }

        try {
            $settings = Settings::where('id', 1)->first();

            // Create quote request
            $quoteRequest = QuoteRequest::create([
                'freight_type' => $request->freight_type,
                'email' => $request->email,
                'departure_country' => $request->departure_country,
                'weight' => $request->weight,
                'recipient_country' => $request->recipient_country,
                'expected_delivery_date' => $request->expected_delivery_date,
                'full_name' => $request->full_name,
                'phone' => $request->phone,
                'company_name' => $request->company_name,
                'description' => $request->description,
                'dimensions' => $request->dimensions,
                'priority' => $request->priority,
                'insurance' => $request->has('insurance'),
                'status' => 'pending'
            ]);

            // Send notification email to admin
            try {
                if ($settings->contact_email) {
                    Mail::to($settings->contact_email)->send(new QuoteRequestReceived($quoteRequest, $settings));
                    \Log::info('Quote request notification sent to admin: ' . $settings->contact_email);
                }
            } catch (\Exception $e) {
                \Log::error('Failed to send quote request notification to admin. Error: ' . $e->getMessage());
            }

            // Send confirmation email to customer
            try {
                Mail::to($quoteRequest->email)->send(new QuoteRequestConfirmation($quoteRequest, $settings));
                \Log::info('Quote request confirmation sent to customer: ' . $quoteRequest->email);
            } catch (\Exception $e) {
                \Log::error('Failed to send quote request confirmation to customer: ' . $quoteRequest->email . '. Error: ' . $e->getMessage());
            }

            if ($request->ajax()) {
                return response()->json([
                    'success' => true,
                    'message' => 'Quote request submitted successfully!',
                    'reference_number' => $quoteRequest->reference_number
                ]);
            }

            return redirect()->back()->with('success', 'Quote request submitted successfully! Reference: ' . $quoteRequest->reference_number);

        } catch (\Exception $e) {
            \Log::error('Quote request submission failed: ' . $e->getMessage());

            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => 'There was an error processing your request. Please try again.'
                ], 500);
            }

            return redirect()->back()->with('error', 'There was an error processing your request. Please try again.');
        }
    }
}
